unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Grids, Spin, ComCtrls, ComInterface;

type
  TIndexArray = array of array of Integer;

  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet3: TTabSheet;
    Panel2: TPanel;
    Label1: TLabel;
    sgLocalizeCollection: TStringGrid;
    Splitter2: TSplitter;
    Panel8: TPanel;
    Label8: TLabel;
    sgPositionsCollection: TStringGrid;
    sgReport: TStringGrid;
    Panel7: TPanel;
    btnReport: TButton;
    rgReportSelection: TRadioGroup;
    edtEntID: TSpinEdit;
    edtPosition: TSpinEdit;
    Label2: TLabel;
    cbPosition: TCheckBox;
    Panel1: TPanel;
    btnImport: TButton;
    btnLocalizeCollection: TButton;
    OpenDialog1: TOpenDialog;
    btnClear: TButton;
    Timer1: TTimer;
    GroupBox1: TGroupBox;
    btnStart: TButton;
    seInterval: TSpinEdit;
    Label3: TLabel;
    Label4: TLabel;
    btnStop: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnLocalizeCollectionClick(Sender: TObject);
    procedure btnImportClick(Sender: TObject);
    procedure btnReportClick(Sender: TObject);
    procedure rgReportSelectionClick(Sender: TObject);
    procedure cbPositionClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnStopClick(Sender: TObject);
  private
    { Private declarations }

    FPositionIndexArray: array of Integer;
    FAdditionalFieldTypeArray: TAdditionalFieldTypeArray;
    FAdditionalFieldArray: array of String;
    FValueArrayObject: TValueArrayObject;
    FPositionIndex: Integer;
    procedure AddRow(AStringGrid: TStringGrid; AValue: TStringList);
    function NowyObiekt(AObjectID: String): Boolean;
    function GetAdditionalFieldsType(AStringList: TStringList; AAdditionalFieldCount: Integer): TAdditionalFieldTypeArray;
    function GetIndex(AIndexArray: TIndexArray; AValue: Integer): Integer;
    procedure RemoveElement(var AArray: array of Integer; AIndex: Integer);
    function GetValueArrayObjectIndex(AEntID: String): Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  EmapaLocalizeCOM_TLB;

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  with sgLocalizeCollection do
  begin
    RowCount := 2;
    ColCount := 11;
    Cells[0, 0] := 'EntID';
    Cells[1, 0] := 'Name';
    Cells[2, 0] := 'IconIndex';
    Cells[3, 0] := 'ShowIcon';
    Cells[4, 0] := 'IconColor';
    Cells[5, 0] := 'PathColor';
    Cells[6, 0] := 'PathWidth';
    Cells[7, 0] := 'Size';
    Cells[8, 0] := 'RemovePrevious';
    Cells[9, 0] := 'PointsConnected';
    Cells[10, 0] := 'ShowName';
  end;

  with sgPositionsCollection do
  begin
    RowCount := 2;
    ColCount := 10;
    Cells[0, 0] := 'EntID';
    Cells[1, 0] := 'Longitude';
    Cells[2, 0] := 'Latitude';
    Cells[3, 0] := 'Time';
    Cells[4, 0] := 'Description';
    Cells[5, 0] := 'IconIndex';
    Cells[6, 0] := 'ShowIcon';
    Cells[7, 0] := 'IconColor';
    Cells[8, 0] := 'ShowName';
    Cells[9, 0] := 'ShowDescription';
  end;

  with sgReport do
  begin
    RowCount := 2;
    ColCount := 8;
    Cells[0, 0] := 'EntID';
    Cells[1, 0] := 'PositionInCollection';
    Cells[2, 0] := 'Time';
    Cells[3, 0] := 'Neighbourhood';
    Cells[4, 0] := 'Name';
    Cells[5, 0] := 'Country';
    Cells[6, 0] := 'County';
    Cells[7, 0] := 'State';
  end;
end;

procedure TForm1.AddRow(AStringGrid: TStringGrid; AValue: TStringList);
var
  i: Integer;
begin
  with AStringGrid do
  begin
    if Enabled then
      RowCount := RowCount + 1
    else
      Enabled := True;

    for i := 0 to AValue.Count-1 do
      Cells[i, RowCount-1] := AValue[i];
  end;
end;

procedure TForm1.btnLocalizeCollectionClick(Sender: TObject);
var
  i, j, tempLength1, tempLength2: Integer;
  AdditionalFieldArray: array of String;
  ValueArrayObject: TValueArrayObject;
  ValueArrayPosition: TValueArrayPosition;
begin
  // Jest POSITION_FIELD_COUNT+1 bo w gridzie trzymany jest dodatkowy parametr
  // bdcy unikalnym identyfikatorem obiektu (EntID)
  for i := POSITION_FIELD_COUNT+1 to sgPositionsCollection.ColCount - 1 do
  begin
    SetLength(AdditionalFieldArray, Length(AdditionalFieldArray)+1);
    AdditionalFieldArray[Length(AdditionalFieldArray)-1] := sgPositionsCollection.Cells[i, 0];
  end;

  for i := 1 to sgLocalizeCollection.RowCount - 1 do
  begin
    SetLength(ValueArrayObject, Length(ValueArrayObject)+1);
    for j := 0 to sgLocalizeCollection.ColCount - 1 do
      ValueArrayObject[Length(ValueArrayObject)-1, j] := sgLocalizeCollection.Cells[j, i];
  end;

  for i := 1 to sgPositionsCollection.RowCount - 1 do
  begin
    SetLength(ValueArrayPosition, Length(ValueArrayPosition)+1);
    tempLength1 := Length(ValueArrayPosition)-1;
    for j := 0 to sgPositionsCollection.ColCount - 1 do
    begin
      SetLength(ValueArrayPosition[tempLength1], Length(ValueArrayPosition[tempLength1])+1);
      tempLength2 := Length(ValueArrayPosition[tempLength1])-1;
      ValueArrayPosition[tempLength1, tempLength2] := sgPositionsCollection.Cells[j, i];
    end;
  end;

  LocalizeCollectionProc(AdditionalFieldArray, ValueArrayObject, ValueArrayPosition, FAdditionalFieldTypeArray, True);
end;

function TForm1.NowyObiekt(AObjectID: String): Boolean;
var
  i: Integer;
begin
  Result := True;
  for i := 1 to sgLocalizeCollection.RowCount-1 do
  begin
    if sgLocalizeCollection.Cells[0, i] = AObjectID then
    begin
      Result := False;
      Break;
    end;
  end;
end;

procedure TForm1.btnImportClick(Sender: TObject);
var
  sl, sl2, sl3: TStringList;
  i, j, AdditionalFieldCount: Integer;
begin
  if Not OpenDialog1.Execute then
    Exit;

  sgLocalizeCollection.Enabled := False;
  sgPositionsCollection.Enabled := False;

  sl := TStringList.Create;
  sl2 := TStringList.Create;
  sl3 := TStringList.Create;

  sl.LoadFromFile(OpenDialog1.FileName);

  for i := 1 to sgLocalizeCollection.RowCount - 1 do
    for j := 0 to sgLocalizeCollection.ColCount - 1 do
      sgLocalizeCollection.Cells[j, i] := '';
  sgLocalizeCollection.RowCount := 2;
  sgLocalizeCollection.ColCount := OBJECT_FIELD_COUNT;
  for i := 1 to sgPositionsCollection.RowCount - 1 do
    for j := 0 to sgPositionsCollection.ColCount - 1 do
      sgPositionsCollection.Cells[j, i] := '';
  sgPositionsCollection.RowCount := 2;
  sgPositionsCollection.ColCount := POSITION_FIELD_COUNT+1; // + EntID obiektu

  sl2.Delimiter := ';';

  if sl.Count > 0 then
  begin
    sl2.DelimitedText := sl[0];
    AdditionalFieldCount := sl2.Count - (OBJECT_FIELD_COUNT + POSITION_FIELD_COUNT);

    for i := OBJECT_FIELD_COUNT + POSITION_FIELD_COUNT to sl2.Count - 1 do
    begin
      sgPositionsCollection.ColCount := sgPositionsCollection.ColCount + 1;
      sgPositionsCollection.Cells[sgPositionsCollection.ColCount-1, 0] := sl2[i];
    end;
  end;

  for i := 1 to sl.Count - 1 do
  begin
    sl2.DelimitedText := sl[i];

    // Brak wymaganych pl
    if sl2.Count < 20 then
      Break;

    if NowyObiekt(sl2[0]) then
    begin
      sl3.Clear;
      sl3.Add(sl2[0]);
      sl3.Add(sl2[10]);
      sl3.Add(sl2[11]);
      sl3.Add(sl2[12]);
      sl3.Add(sl2[13]);
      sl3.Add(sl2[14]);
      sl3.Add(sl2[15]);
      sl3.Add(sl2[16]);
      sl3.Add(sl2[17]);
      sl3.Add(sl2[18]);
      sl3.Add(sl2[19]);
      AddRow(sgLocalizeCollection, sl3);
    end
    else
      sgLocalizeCollection.Enabled := True;

    sl3.Clear;
    sl3.Add(sl2[0]);
    sl3.Add(Copy(sl2[1], 1, Length(sl2[1])-1));
    sl3.Add(Copy(sl2[2], 1, Length(sl2[2])-1));
    sl3.Add(sl2[3]);
    sl3.Add(sl2[4]);
    sl3.Add(sl2[5]);
    sl3.Add(sl2[6]);
    sl3.Add(sl2[7]);
    sl3.Add(sl2[8]);
    sl3.Add(sl2[9]);
    for j := OBJECT_FIELD_COUNT + POSITION_FIELD_COUNT to sl2.Count-1 do
      sl3.Add(sl2[j]);
    AddRow(sgPositionsCollection, sl3);
  end;

  FAdditionalFieldTypeArray := GetAdditionalFieldsType(sl, AdditionalFieldCount);

  sl3.Free;
  sl2.Free;
  sl.Free;

  sgLocalizeCollection.Enabled := True;
  sgPositionsCollection.Enabled := True;
end;

procedure TForm1.btnReportClick(Sender: TObject);
var
  sl: TStringList;
  ReportArray: TReportArray;
  ReportAccuracy: ReportSelectionEnum;
  ovPosition: OleVariant;
  i, j: Integer;
begin
  sl := TStringList.Create;

  sgReport.Enabled := False;
  sgReport.RowCount := 2;

  ReportAccuracy := ReportAll;
  case rgReportSelection.ItemIndex of
    1: ReportAccuracy := ReportLast;
    2: ReportAccuracy := ReportSelected;
  end;

  if edtPosition.Enabled then
    ovPosition := edtPosition.Value
  else
    ovPosition := EmptyParam;

  ReportArray := RetrieveReportProc(ReportAccuracy, edtEntID.Value, ovPosition);
  for i := Low(ReportArray) to High(ReportArray) do
  begin
    sl.Clear;
    for j := 0 to 7 do
      sl.Add(ReportArray[i, j]);
    AddRow(sgReport, sl);
  end;

  sl.Free;
end;

procedure TForm1.rgReportSelectionClick(Sender: TObject);
begin
  if rgReportSelection.ItemIndex = 2 then
  begin
    edtEntID.Enabled := True;
    cbPosition.Enabled := True;
  end
  else begin
    edtEntID.Enabled := False;
    cbPosition.Enabled := False;
  end;
end;

procedure TForm1.cbPositionClick(Sender: TObject);
begin
  edtPosition.Enabled := cbPosition.Checked;
end;

procedure TForm1.btnClearClick(Sender: TObject);
begin
  CleanLocalizeInfoProc;
end;

function TForm1.GetAdditionalFieldsType(AStringList: TStringList; AAdditionalFieldCount: Integer): TAdditionalFieldTypeArray;
var
  i, j: Integer;
  sRow: String;
  bBreak: Boolean;
begin
  SetLength(Result, AAdditionalFieldCount);
  for i := 0 to Length(Result)-1 do
    Result[i] := aftUnknown;

  for i := 1 to AStringList.Count - 1 do
  begin
    sRow := AStringList[i];
    // Usu pola wymagane
    for j := 0 to OBJECT_FIELD_COUNT + POSITION_FIELD_COUNT - 1 do
      Delete(sRow, 1, Pos(';', sRow));

    for j := 0 to AAdditionalFieldCount - 1 do
    begin
      if sRow[1] = '"' then
        Result[j] := aftString
      else if sRow[1] <> ';' then
        Result[j] := aftNumeric;

      Delete(sRow, 1, Pos(';', sRow));
    end;

    bBreak := True;
    for j := 0 to Length(Result)-1 do
      if Result[j] = aftUnknown then
        bBreak := False;

    if bBreak then
     Break;
  end;
end;

function TForm1.GetIndex(AIndexArray: TIndexArray; AValue: Integer): Integer;
var
  i: Integer;
begin
  Result := -1;
  for i := Low(AIndexArray) to High(AIndexArray) do
    if AIndexArray[i, 0] = AValue then
    begin
      Result := i;
      Break;
    end;
end;

procedure TForm1.RemoveElement(var AArray: array of Integer; AIndex: Integer);
var
  i: Integer;
begin
  if Length(AArray) > 1 then
    for i := AIndex+1 to High(AArray) do
      AArray[i-1] := AArray[i];
end;

procedure TForm1.btnStartClick(Sender: TObject);
var
  bBreak: Boolean;
  i, j, tempLength1, tempLength2, Index: Integer;
  ValueArrayPosition: TValueArrayPosition;
  IndexArray: TIndexArray;
begin
  SetLength(FAdditionalFieldArray, 0);
  SetLength(FValueArrayObject, 0);
  SetLength(FPositionIndexArray, 0);
  FPositionIndex := 0;

  // Jest POSITION_FIELD_COUNT+1 bo w gridzie trzymany jest dodatkowy parametr
  // bdcy unikalnym identyfikatorem obiektu (EntID)
  for i := POSITION_FIELD_COUNT+1 to sgPositionsCollection.ColCount - 1 do
  begin
    SetLength(FAdditionalFieldArray, Length(FAdditionalFieldArray)+1);
    FAdditionalFieldArray[Length(FAdditionalFieldArray)-1] := sgPositionsCollection.Cells[i, 0];
  end;

  for i := 1 to sgLocalizeCollection.RowCount - 1 do
  begin
    SetLength(FValueArrayObject, Length(FValueArrayObject)+1);
    for j := 0 to sgLocalizeCollection.ColCount - 1 do
      FValueArrayObject[Length(FValueArrayObject)-1, j] := sgLocalizeCollection.Cells[j, i];
  end;

  for i := 1 to sgPositionsCollection.RowCount - 1 do
  begin
    Index := GetIndex(IndexArray, StrToInt(sgPositionsCollection.Cells[0, i]));
    if Index < 0 then
    begin
      SetLength(IndexArray, Length(IndexArray)+1);
      Index := Length(IndexArray)-1;

      SetLength(IndexArray[Index], 1);
      IndexArray[Index, 0] := StrToInt(sgPositionsCollection.Cells[0, i]);
    end;

    SetLength(IndexArray[Index], Length(IndexArray[Index])+1);
    IndexArray[Index, Length(IndexArray[Index])-1] := i;
  end;

  // Usunicie kolumny z ID obiektu
  for i := Low(IndexArray) to High(IndexArray) do
  begin
    if Length(IndexArray[i]) > 1 then
    begin
      RemoveElement(IndexArray[i], 0);
      SetLength(IndexArray[i], Length(IndexArray[i])-1);
    end;
  end;

  repeat
    bBreak := True;
    for i := Low(IndexArray) to High(IndexArray) do
    begin
      if Length(IndexArray[i]) > 0 then
      begin
        bBreak := False;

        SetLength(FPositionIndexArray, Length(FPositionIndexArray)+1);
        FPositionIndexArray[Length(FPositionIndexArray)-1] := IndexArray[i, 0];

        if Length(IndexArray[i]) > 1 then
          RemoveElement(IndexArray[i], 0);
        SetLength(IndexArray[i], Length(IndexArray[i])-1);
      end;
    end;
  until bBreak;

  Timer1.Interval := 1; // wymuszenie wywoania od razu f-ji osugi zegara
  Timer1.Enabled := True;
end;

function TForm1.GetValueArrayObjectIndex(AEntID: String): Integer;
var
  i: Integer;
begin
  Result := -1;
  for i := 0 to Length(FValueArrayObject) - 1 do
  begin
    if FValueArrayObject[i, 0] = AEntID then
    begin
      Result := i;
      Break;
    end;
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  ValueArrayPosition: TValueArrayPosition;
  ValueArrayObject: TValueArrayObject;
  i, Index: Integer;
begin
  if FPositionIndex = 0 then
    Timer1.Interval := seInterval.Value; // ustawienie waciwego interwau

  if FPositionIndex >= Length(FPositionIndexArray) then
  begin
    Timer1.Enabled := False;
    Exit;
  end;

  SetLength(ValueArrayPosition, 1);
  for i := 0 to sgPositionsCollection.ColCount - 1 do
  begin
    SetLength(ValueArrayPosition[0], Length(ValueArrayPosition[0])+1);
    ValueArrayPosition[0, Length(ValueArrayPosition[0])-1] := sgPositionsCollection.Cells[i, FPositionIndexArray[FPositionIndex]];
  end;

  // znalezienie waciwego obiektu
  SetLength(ValueArrayObject, 1);
  Index := GetValueArrayObjectIndex(ValueArrayPosition[0, 0]);
  if Index >= 0 then
    for i := 0 to Length(FValueArrayObject[Index]) - 1 do
      ValueArrayObject[0, i] := FValueArrayObject[Index, i];

  LocalizeCollectionProc(FAdditionalFieldArray, ValueArrayObject, ValueArrayPosition, FAdditionalFieldTypeArray, False);

  Inc(FPositionIndex);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Timer1.Enabled := False;
end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
  Timer1.Enabled := False;
end;

end.
